
# はじめに

本 DFSS Repository は，国立研究開発法人土木研究所 土砂管理研究グループ 火山・土石流チームが土木研究所資料第4419号（山崎ほか [1]）において公開した DFSS (Debris Flow Simulator for Sabo) のソースコードおよびデータの管理用の Github Repository です。
DFSS は，近年，降雨や空中写真，標高データなどの時間・空間分解能が高く，かつ，リアルタイム性の高いデータが得られる環境が整いつつあることから，
土石流の氾濫範囲の評価のさらなる精度向上を図るために，火山・土石流チームで研究・開発用途に開発しているオープンソースコードの土石流流出・氾濫モデルです。

公開目的は，開発成果物の再利用性・転用可能性を確保し，継続的な改善サイクルを生み出すことに加え，土石流等に関する数値計算技術に関する技術やノウハウの発展的な蓄積あるいは開発者の育成を促進することなど（清水ほか [3]）にあります。

そこで，改善されたプログラムも協調領域に存在させることを意図して，下に示すライセンスや利用規約に従って，改変を含めて自由に利用できることとしました。

1. 著作権表示
2. 継承（二次著作物を作った場合，CC BY-SA 4.0 のライセンスを付与）

利用に当たり，利用者はいかなる利用に対しても以下の点を承諾したものとします。

1. 利用者は商用利用や改変も含めて自由に利用できること
2. 利用者の利用に対して，著作権者および関係者は一切その責任を負わないこと
3. 著作者および関係者は一切のサポートを行わないこと



なお，1．著作権表示について，著作権者は土木研究所となります。
また，2．継承について，本ライセンスは GPL v3 に相当するため，変更したコードを業務や研究で使用した場合には同じライセンスを付けたオープンソースプログラムにしなければなりません。


# ライセンス

[クリエイティブ・コモンズ表示-継承 4.0 国際　パブリック・ライセンス（CC BY-SA 4.0）](https://creativecommons.org/licenses/by-sa/4.0/deed.ja)

なお，CC BY-SA 4.0 は GPL v3 への一方向性互換性があるため，本Github 上のライセンスは GPL-3.0 license としています（[参考](https://creativecommons.jp/2016/01/25/cc-by-sa-%EF%BC%88%E8%A1%A8%E7%A4%BA-%E7%B6%99%E6%89%BF%EF%BC%89-4-0%E3%81%8B%E3%82%89gpl-v3%E3%81%B8%E3%81%AE%E4%B8%80%E6%96%B9%E5%90%91%E3%81%AE%E4%BA%92%E6%8F%9B%E3%81%8C%E5%AE%9F%E7%8F%BE/) ）



# 使用方法

+ `01_Terauchi, 02_Arimura, 03_Furuegawa` は，参考文献 [1] の付録Aを参照してください。計算方法や結果は同文献の本文に掲載されています。各フォルダ内のバッチファイルにプログラムの実行方法が記載されています。

+ `13_Furuegawa_flattenDir` は，`03_Furuegawa` を再構成し上流から下流まで計算できるように編集したものです。使い方は `./13_Furuegawa_flattenDir/README.md` を参照してください。


# 利用上のお願い

1. DFSSを利用の際は，参考文献 [1], [2] あるいは，本 DFSS Repository の github URL のいずれかを引用文献や謝辞等に明記して下さい。

2. DFSSを用いて作成された学術論文・学会発表予稿原稿・成果報告等で，出版された場合，あるいは何かに利用した場合には，その旨を次の連絡先に送っていただければ幸いです。
    pwri-volcano-debrisflow-team-git [\+\-\*/] pwri.go.jp ([\+\-\*/] は at mark に変更してください。）


以上のお願いは，利用実績を蓄積することによりオープンソースコードおよびデータ提供の必要性・有益性を把握するためのものです。



# 参考文献

[1] 山崎祐介・清水武志・石井靖雄・石田孝司：降雨流出解析と連動した土石流の流出・氾濫解析法, 土木研究所資料, 第4419号, 52 p., 土木研究所, 2022, https://thesis.pwri.go.jp/public_detail/100007/ (accessed 2023/2/1)

[2] Takeshi SHIMIZU, Yusuke YAMAZAKI, Naoki IMAMORI, Development of an open source Debris Flow Simulator for "SABO": DFSS, 8th Internatinational Conference on Debris Flow Hazard Mitigation, 2023 （予定）

[3] 清水武志・山崎祐介・今森直紀・石田孝司：火山噴火後を想定した土石流氾濫計算オープンソースプログラムの公開，砂防学会研究発表会概要集，R4-7, 2022，https://www.jsece.or.jp/event/conf/abstract/2022/pdf/141.pdf (accessed 2023/2/1)



# 免責事項

本 DFSS Repository に公開する情報を利用することおよび二次著作物を利用することによって生じる直接・間接を含む如何なる損害に対しても，土木研究所および関係者は一切の責任を負いません。


# その他

本 DFSS Repository の運営やデータ公開内容は，予告なく変更する場合があります。

